import { toTree } from '../../json-text/toTree';
import { formatError } from '../util';
export class CliParamPlan {
    param = 'plan';
    title = 'Show execution plan';
    createInstance = (cli, pointer, rawValue) => new (class {
        onBeforeCall = async (method, ctx) => {
            const fn = cli.router.routes[method];
            if (!fn)
                throw new Error(`Method ${method} not found`);
            const out = {
                Method: method,
            };
            try {
                const validator = fn.req.validator('object');
                const error = validator(cli.request);
                if (error)
                    throw error;
                out.Validation = 'OK';
            }
            catch (error) {
                out.Validation = 'Failed';
                out.ValidationError = formatError(error);
            }
            out.Request = cli.request;
            cli.stdout.write(toTree(out) + '\n');
            cli.exit(0);
        };
    })();
}
