import { applyPatch } from '../../json-patch';
import { toPath } from '../../json-pointer';
export class CliParamJson {
    param = 'json';
    short = 'j';
    title = 'Set JSON value';
    example = '--j/foo=\'{"a":1}\'';
    createInstance = (cli, pointer, rawValue) => new (class {
        onRequest = async () => {
            const value = JSON.parse(String(rawValue));
            const path = toPath(pointer);
            cli.request = applyPatch(cli.request, [{ op: 'add', path, value }], { mutate: true }).doc;
        };
    })();
}
