export class CliParamFormat {
    param = 'format';
    short = 'fmt';
    title = 'Codec to use for req/res';
    example = '--fmt=json:cbor';
    help = 'Codec format to use for encoding/decoding request/response values. To specify both request and response codecs use "<codec>", or "<reqCodec>:<resCodec>" to specify them separately.';
    examples = ['--format=cbor', '--format=cbor:json', '--fmt=json:msgpack', '--fmt=json:tree'];
    createInstance = (cli, pointer, value) => new (class {
        onParam = async () => {
            const format = String(value);
            const codecs = cli.codecs.getCodecs(format);
            const [requestCodec, responseCodec] = codecs;
            cli.requestCodec = requestCodec;
            cli.responseCodec = responseCodec;
        };
    })();
}
