import { applyPatch } from '../../json-patch';
import { find, toPath, validateJsonPointer } from '../../json-pointer';
import { promises } from 'fs';
export class CliParamFile {
    param = 'file';
    short = 'f';
    title = 'Read value from file';
    example = '--f/foo=test.json:json:/a/b/c';
    createInstance = (cli, pointer, rawValue) => new (class {
        onRequest = async () => {
            const [filename, fileCodec, filePointer] = String(rawValue).split(':');
            const codec = fileCodec ? cli.codecs.get(fileCodec) : cli.requestCodec;
            const uint8 = await promises.readFile(filename);
            let value = codec.decode(uint8);
            if (filePointer) {
                validateJsonPointer(filePointer);
                value = find(value, toPath(filePointer)).val;
            }
            validateJsonPointer(pointer);
            const path = toPath(pointer);
            applyPatch(cli.request, [{ op: 'add', path, value }], { mutate: true });
        };
    })();
}
