import { applyPatch } from '../../json-patch';
import { toPath } from '../../json-pointer';
export class CliParamBool {
    param = 'bool';
    short = 'b';
    title = 'Set boolean value';
    example = '--b/foo=true';
    createInstance = (cli, pointer, rawValue) => new (class {
        onRequest = async () => {
            const value = Boolean(JSON.parse(String(rawValue)));
            const path = toPath(pointer);
            cli.request = applyPatch(cli.request, [{ op: 'add', path, value }], { mutate: true }).doc;
        };
    })();
}
