import { JsonDecoder } from '../../json-pack/json/JsonDecoder';
import { JsonEncoder } from '../../json-pack/json/JsonEncoder';
import { bufferToUint8Array } from '../../util/buffers/bufferToUint8Array';
export class CliCodecJson2 {
    writer;
    id = 'json2';
    description = 'JSON codec with 2 space pretty-printing';
    encoder;
    decoder;
    constructor(writer) {
        this.writer = writer;
        this.encoder = new JsonEncoder(writer);
        this.decoder = new JsonDecoder();
    }
    encode(value) {
        const uint8 = this.encoder.encode(value);
        const pojo = JSON.parse(Buffer.from(uint8).toString('utf8'));
        const json = JSON.stringify(pojo, null, 2) + '\n';
        return bufferToUint8Array(Buffer.from(json, 'utf8'));
    }
    decode(bytes) {
        return this.decoder.read(bytes);
    }
}
