import { JsonDecoder } from '../../json-pack/json/JsonDecoder';
import { JsonEncoder } from '../../json-pack/json/JsonEncoder';
export class CliCodecJson {
    writer;
    id = 'json';
    description = 'JSON codec, which also supports binary data';
    encoder;
    decoder;
    constructor(writer) {
        this.writer = writer;
        this.encoder = new JsonEncoder(writer);
        this.decoder = new JsonDecoder();
    }
    encode(value) {
        return this.encoder.encode(value);
    }
    decode(bytes) {
        return this.decoder.read(bytes);
    }
}
