const CODEC_REGEX = /(\w{0,32})(?:\:(\w{0,32}))?/;
export class CliCodecs {
    defaultCodec = 'json4';
    codecs = new Map();
    register(codec) {
        this.codecs.set(codec.id, codec);
    }
    get(id) {
        let codec = this.codecs.get(id);
        if (!id)
            codec = this.codecs.get(this.defaultCodec);
        if (!codec)
            throw new Error(`Codec not found: ${id}`);
        return codec;
    }
    getCodecs(format) {
        if (typeof format !== 'string')
            throw new Error(`Invalid --format type.`);
        if (!format) {
            const codec = this.get('');
            return [codec, codec];
        }
        const match = CODEC_REGEX.exec(format);
        if (!match)
            throw new Error(`Invalid format: ${format}`);
        const request = match[1];
        const response = match[2] ?? request;
        return [this.get(request), this.get(response)];
    }
}
