import { JsonPackExtension, JsonPackValue } from '../json-pack/msgpack';
import { isUint8Array } from '../util/buffers/isUint8Array';
const arraySize = (arr) => {
    let size = 2;
    for (let i = arr.length - 1; i >= 0; i--)
        size += msgpackSizeFast(arr[i]);
    return size;
};
const objectSize = (obj) => {
    let size = 2;
    for (const key in obj)
        if (obj.hasOwnProperty(key))
            size += 2 + key.length + msgpackSizeFast(obj[key]);
    return size;
};
export const msgpackSizeFast = (value) => {
    if (value === null)
        return 1;
    switch (typeof value) {
        case 'number':
            return 9;
        case 'string':
            return 4 + value.length;
        case 'boolean':
            return 1;
    }
    if (value instanceof Array)
        return arraySize(value);
    if (isUint8Array(value))
        return 5 + value.length;
    if (value instanceof JsonPackValue)
        return value.val.length;
    if (value instanceof JsonPackExtension)
        return 6 + value.val.length;
    return objectSize(value);
};
