import { hasOwnProperty } from '../util/hasOwnProperty';
export const get = (val, path) => {
    const pathLength = path.length;
    let key;
    if (!pathLength)
        return val;
    for (let i = 0; i < pathLength; i++) {
        key = path[i];
        if (val instanceof Array) {
            const length = val.length;
            if (key === '-')
                return undefined;
            const key2 = ~~key;
            if ('' + key2 !== key)
                return undefined;
            key = key2;
            if (key < 0)
                return undefined;
            val = val[key];
        }
        else if (typeof val === 'object') {
            if (!val || !hasOwnProperty(val, key))
                return undefined;
            val = val[key];
        }
        else
            return undefined;
    }
    return val;
};
