import { hasOwnProperty } from '../../util/hasOwnProperty';
import { isInteger, unescapeComponent } from '../util';
const { isArray } = Array;
export const findByPointer = (pointer, val) => {
    if (!pointer)
        return { val };
    let obj;
    let key;
    let indexOfSlash = 0;
    pointer = pointer.substr(1);
    while (pointer) {
        indexOfSlash = pointer.indexOf('/');
        let component;
        if (indexOfSlash > -1) {
            component = pointer.substring(0, indexOfSlash);
            pointer = pointer.substring(indexOfSlash + 1);
        }
        else {
            component = pointer;
            pointer = '';
        }
        key = unescapeComponent(component);
        obj = val;
        if (isArray(obj)) {
            if (key === '-')
                key = obj.length;
            else {
                if (!isInteger(key))
                    throw new Error('INVALID_INDEX');
                key = Number(key);
                if (key < 0)
                    throw new Error('INVALID_INDEX');
            }
            val = hasOwnProperty(obj, String(key)) ? obj[key] : undefined;
        }
        else if (typeof obj === 'object' && !!obj) {
            val = hasOwnProperty(obj, String(key)) ? obj[key] : undefined;
        }
        else
            throw new Error('NOT_FOUND');
    }
    return { val, obj, key };
};
