const { isArray } = Array;
export const isTextNode = (node) => !!node && typeof node === 'object' && typeof node.text === 'string';
export const isElementNode = (node) => !!node && typeof node === 'object' && isArray(node.children);
export const createMatcherDefault = (pattern, ignoreCase) => {
    const reg = new RegExp(pattern, ignoreCase ? 'i' : undefined);
    return (value) => reg.test(value);
};
