import { AbstractPredicateOp } from './AbstractPredicateOp';
import { find, formatJsonPointer } from '../../json-pointer';
export class OpUndefined extends AbstractPredicateOp {
    constructor(path) {
        super(path);
    }
    op() {
        return 'undefined';
    }
    code() {
        return 38;
    }
    test(doc) {
        try {
            const { val } = find(doc, this.path);
            const test = val === undefined;
            return test;
        }
        catch (error) {
            if (error.message === 'NOT_FOUND')
                return true;
            throw error;
        }
    }
    toJson(parent) {
        const op = {
            op: 'undefined',
            path: formatJsonPointer(parent ? this.path.slice(parent.path.length) : this.path),
        };
        return op;
    }
    toCompact(parent, verbose) {
        const opcode = verbose ? 'undefined' : 38;
        return [opcode, parent ? this.path.slice(parent.path.length) : this.path];
    }
    encode(encoder, parent) {
        encoder.encodeArrayHeader(2);
        encoder.writer.u8(38);
        encoder.encodeArray(parent ? this.path.slice(parent.path.length) : this.path);
    }
}
