import { AbstractPredicateOp } from './AbstractPredicateOp';
import { find, formatJsonPointer } from '../../json-pointer';
export class OpTestStringLen extends AbstractPredicateOp {
    len;
    not;
    constructor(path, len, not) {
        super(path);
        this.len = len;
        this.not = not;
    }
    op() {
        return 'test_string_len';
    }
    code() {
        return 41;
    }
    test(doc) {
        const { val } = find(doc, this.path);
        if (typeof val !== 'string')
            return false;
        const length = val.length;
        const test = length >= this.len;
        return this.not ? !test : test;
    }
    toJson(parent) {
        const op = {
            op: 'test_string_len',
            path: formatJsonPointer(parent ? this.path.slice(parent.path.length) : this.path),
            len: this.len,
        };
        if (this.not)
            op.not = this.not;
        return op;
    }
    toCompact(parent, verbose) {
        const opcode = verbose ? 'test_string_len' : 41;
        const path = parent ? this.path.slice(parent.path.length) : this.path;
        return this.not ? [opcode, path, this.len, 1] : [opcode, path, this.len];
    }
    encode(encoder, parent) {
        encoder.encodeArrayHeader(this.not ? 4 : 3);
        encoder.writer.u8(41);
        encoder.encodeArray(parent ? this.path.slice(parent.path.length) : this.path);
        encoder.encodeNumber(this.len);
        if (this.not)
            encoder.writer.u8(1);
    }
}
