import { find, formatJsonPointer } from '../../json-pointer';
import { AbstractPredicateOp } from './AbstractPredicateOp';
import { deepEqual } from '../../json-equal/deepEqual';
export class OpTest extends AbstractPredicateOp {
    value;
    not;
    constructor(path, value, not) {
        super(path);
        this.value = value;
        this.not = not;
    }
    op() {
        return 'test';
    }
    code() {
        return 5;
    }
    test(doc) {
        const { val } = find(doc, this.path);
        if (val === undefined)
            return !!this.not;
        const test = deepEqual(val, this.value);
        return this.not ? !test : test;
    }
    toJson(parent) {
        const op = {
            op: 'test',
            path: formatJsonPointer(parent ? this.path.slice(parent.path.length) : this.path),
            value: this.value,
        };
        if (this.not)
            op.not = this.not;
        return op;
    }
    toCompact(parent, verbose) {
        const path = parent ? this.path.slice(parent.path.length) : this.path;
        const opcode = verbose ? 'test' : 5;
        return this.not ? [opcode, path, this.value, 1] : [opcode, path, this.value];
    }
    encode(encoder, parent) {
        encoder.encodeArrayHeader(this.not ? 4 : 3);
        encoder.writer.u8(5);
        encoder.encodeArray(parent ? this.path.slice(parent.path.length) : this.path);
        encoder.encodeAny(this.value);
        if (this.not)
            encoder.writer.u8(1);
    }
}
