import { AbstractOp } from './AbstractOp';
import { find, isObjectReference, isArrayReference, formatJsonPointer } from '../../json-pointer';
export class OpRemove extends AbstractOp {
    oldValue;
    constructor(path, oldValue) {
        super(path);
        this.oldValue = oldValue;
    }
    op() {
        return 'remove';
    }
    code() {
        return 1;
    }
    apply(doc) {
        const ref = find(doc, this.path);
        if (ref.val === undefined)
            throw new Error('NOT_FOUND');
        if (isObjectReference(ref))
            delete ref.obj[ref.key];
        else if (isArrayReference(ref)) {
            if (ref.val !== undefined)
                ref.obj.splice(ref.key, 1);
        }
        else
            doc = null;
        return { doc, old: ref.val };
    }
    toJson(parent) {
        const json = {
            op: 'remove',
            path: formatJsonPointer(this.path),
        };
        if (this.oldValue !== undefined)
            json.oldValue = this.oldValue;
        return json;
    }
    toCompact(parent, verbose) {
        const opcode = verbose ? 'remove' : 1;
        return this.oldValue === undefined
            ? [opcode, this.path]
            : [opcode, this.path, this.oldValue];
    }
    encode(encoder, parent) {
        const hasOldValue = this.oldValue !== undefined;
        encoder.encodeArrayHeader(hasOldValue ? 3 : 2);
        encoder.writer.u8(1);
        encoder.encodeArray(this.path);
        if (hasOldValue)
            encoder.encodeAny(this.oldValue);
    }
}
