import { AbstractOp } from './AbstractOp';
import { OpRemove } from './OpRemove';
import { OpAdd } from './OpAdd';
import { toPath, formatJsonPointer } from '../../json-pointer';
export class OpMove extends AbstractOp {
    from;
    constructor(path, from) {
        super(path);
        this.from = from;
    }
    op() {
        return 'move';
    }
    code() {
        return 4;
    }
    apply(doc) {
        const remove = new OpRemove(toPath(this.from), undefined).apply(doc);
        const add = new OpAdd(this.path, remove.old).apply(remove.doc);
        return add;
    }
    toJson(parent) {
        return {
            op: 'move',
            path: formatJsonPointer(this.path),
            from: formatJsonPointer(this.from),
        };
    }
    toCompact(parent, verbose) {
        const opcode = verbose ? 'move' : 4;
        return [opcode, this.path, this.from];
    }
    encode(encoder, parent) {
        encoder.encodeArrayHeader(3);
        encoder.writer.u8(4);
        encoder.encodeArray(this.path);
        encoder.encodeArray(this.from);
    }
}
