import { AbstractPredicateOp } from './AbstractPredicateOp';
import { find, formatJsonPointer } from '../../json-pointer';
export class OpMore extends AbstractPredicateOp {
    value;
    constructor(path, value) {
        super(path);
        this.value = value;
    }
    op() {
        return 'more';
    }
    code() {
        return 36;
    }
    test(doc) {
        const { val } = find(doc, this.path);
        if (typeof val !== 'number')
            return false;
        const test = val > this.value;
        return test;
    }
    toJson(parent) {
        const op = {
            op: 'more',
            path: formatJsonPointer(parent ? this.path.slice(parent.path.length) : this.path),
            value: this.value,
        };
        return op;
    }
    toCompact(parent, verbose) {
        const opcode = verbose ? 'more' : 36;
        return [opcode, parent ? this.path.slice(parent.path.length) : this.path, this.value];
    }
    encode(encoder, parent) {
        encoder.encodeArrayHeader(3);
        encoder.writer.u8(36);
        encoder.encodeArray(parent ? this.path.slice(parent.path.length) : this.path);
        encoder.encodeNumber(this.value);
    }
}
