import { AbstractOp } from './AbstractOp';
import { find, formatJsonPointer } from '../../json-pointer';
export class OpInc extends AbstractOp {
    inc;
    constructor(path, inc) {
        super(path);
        this.inc = inc;
    }
    op() {
        return 'inc';
    }
    code() {
        return 9;
    }
    apply(doc) {
        const ref = find(doc, this.path);
        const result = this.inc + Number(ref.val);
        if (ref.obj)
            ref.obj[ref.key] = result;
        else
            doc = result;
        return { doc, old: ref.val };
    }
    toJson(parent) {
        const op = {
            op: 'inc',
            path: formatJsonPointer(this.path),
            inc: this.inc,
        };
        return op;
    }
    toCompact(parent, verbose) {
        const opcode = verbose ? 'inc' : 9;
        return [opcode, this.path, this.inc];
    }
    encode(encoder, parent) {
        encoder.encodeArrayHeader(3);
        encoder.writer.u8(9);
        encoder.encodeArray(this.path);
        encoder.encodeNumber(this.inc);
    }
}
