import { find, formatJsonPointer } from '../../json-pointer';
import { AbstractPredicateOp } from './AbstractPredicateOp';
import { deepEqual } from '../../json-equal/deepEqual';
export class OpIn extends AbstractPredicateOp {
    value;
    constructor(path, value) {
        super(path);
        this.value = value;
    }
    op() {
        return 'in';
    }
    code() {
        return 33;
    }
    test(doc) {
        const { val } = find(doc, this.path);
        for (const x of this.value)
            if (deepEqual(val, x))
                return true;
        return false;
    }
    toJson(parent) {
        const op = {
            op: 'in',
            path: formatJsonPointer(parent ? this.path.slice(parent.path.length) : this.path),
            value: this.value,
        };
        return op;
    }
    toCompact(parent, verbose) {
        const opcode = verbose ? 'in' : 33;
        return [opcode, parent ? this.path.slice(parent.path.length) : this.path, this.value];
    }
    encode(encoder, parent) {
        encoder.encodeArrayHeader(3);
        encoder.writer.u8(33);
        encoder.encodeArray(parent ? this.path.slice(parent.path.length) : this.path);
        encoder.encodeArray(this.value);
    }
}
