import { AbstractOp } from './AbstractOp';
import { find, formatJsonPointer } from '../../json-pointer';
import { OpAdd } from './OpAdd';
import { clone as deepClone } from '../../json-clone/clone';
export class OpCopy extends AbstractOp {
    from;
    constructor(path, from) {
        super(path);
        this.from = from;
    }
    op() {
        return 'copy';
    }
    code() {
        return 3;
    }
    apply(doc) {
        const { val } = find(doc, this.from);
        if (val === undefined)
            throw new Error('NOT_FOUND');
        const add = new OpAdd(this.path, deepClone(val)).apply(doc);
        return add;
    }
    toJson(parent) {
        return {
            op: 'copy',
            path: formatJsonPointer(this.path),
            from: formatJsonPointer(this.from),
        };
    }
    toCompact(parent, verbose) {
        const opcode = verbose ? 'copy' : 3;
        return [opcode, this.path, this.from];
    }
    encode(encoder, parent) {
        encoder.encodeArrayHeader(3);
        encoder.writer.u8(3);
        encoder.encodeArray(this.path);
        encoder.encodeArray(this.from);
    }
}
