import { AbstractSecondOrderPredicateOp } from './AbstractSecondOrderPredicateOp';
import { formatJsonPointer } from '../../json-pointer';
export class OpAnd extends AbstractSecondOrderPredicateOp {
    ops;
    constructor(path, ops) {
        super(path, ops);
        this.ops = ops;
    }
    op() {
        return 'and';
    }
    code() {
        return 43;
    }
    test(doc) {
        for (const op of this.ops)
            if (!op.test(doc))
                return false;
        return true;
    }
    toJson(parent) {
        const op = {
            op: 'and',
            path: formatJsonPointer(parent ? this.path.slice(parent.path.length) : this.path),
            apply: this.ops.map((op) => op.toJson(this)),
        };
        return op;
    }
    toCompact(parent, verbose) {
        const opcode = verbose ? 'and' : 43;
        return [
            opcode,
            parent ? this.path.slice(parent.path.length) : this.path,
            this.ops.map((op) => op.toCompact(this, verbose)),
        ];
    }
    encode(encoder, parent) {
        const path = parent ? this.path.slice(parent.path.length) : this.path;
        encoder.encodeArrayHeader(3);
        encoder.writer.u8(43);
        encoder.encodeArray(path);
        const length = this.ops.length;
        encoder.encodeArrayHeader(length);
        for (let i = 0; i < length; i++)
            this.ops[i].encode(encoder, this);
    }
}
