import { AbstractOp } from './AbstractOp';
import { find, formatJsonPointer } from '../../json-pointer';
import { clone as deepClone } from '../../json-clone/clone';
export class OpAdd extends AbstractOp {
    value;
    constructor(path, value) {
        super(path);
        this.value = value;
    }
    op() {
        return 'add';
    }
    code() {
        return 0;
    }
    apply(doc) {
        const { val, key, obj } = find(doc, this.path);
        const value = deepClone(this.value);
        if (!obj)
            doc = value;
        else if (typeof key === 'string')
            obj[key] = value;
        else {
            const length = obj.length;
            if (key < length)
                obj.splice(key, 0, value);
            else if (key > length)
                throw new Error('INVALID_INDEX');
            else
                obj.push(value);
        }
        return { doc, old: val };
    }
    toJson(parent) {
        return {
            op: 'add',
            path: formatJsonPointer(this.path),
            value: this.value,
        };
    }
    toCompact(parent, verbose) {
        const opcode = verbose ? 'add' : 0;
        return [opcode, this.path, this.value];
    }
    encode(encoder) {
        encoder.encodeArrayHeader(3);
        encoder.writer.u8(0);
        encoder.encodeArray(this.path);
        encoder.encodeAny(this.value);
    }
}
