import { compileClosure } from '../../../util/codegen';
import { $findRef } from '../../../json-pointer/codegen/findRef';
export const $$add = (op) => {
    const find = $findRef(op.path);
    const js = `
(function(find, path){
  return function(doc){
    var value = ${JSON.stringify(op.value)};
    var f = find(doc);
    var obj = f.obj, key = f.key, val = f.val;
    if (!obj) doc = value;
    else if (typeof key === 'string') obj[key] = value;
    else {
      var length = obj.length;
      if (key < length) obj.splice(key, 0, value);
      else if (key > length) throw new Error('INVALID_INDEX');
      else obj.push(value);
    }
    return doc;
  };
})`;
    return {
        deps: [find, op.path],
        js: js,
    };
};
export const $add = (op) => compileClosure($$add(op));
