import { clone as deepClone } from '../../json-clone/clone';
import { operationToOp } from '../codec/json';
export function applyOp(doc, op, mutate) {
    if (!mutate)
        doc = deepClone(doc);
    return op.apply(doc);
}
export function applyOps(doc, ops, mutate) {
    if (!mutate)
        doc = deepClone(doc);
    const res = [];
    const length = ops.length;
    for (let i = 0; i < length; i++) {
        const opResult = ops[i].apply(doc);
        doc = opResult.doc;
        res.push(opResult);
    }
    return { doc, res };
}
export function applyPatch(doc, patch, options) {
    if (!options.mutate)
        doc = deepClone(doc);
    const res = [];
    const length = patch.length;
    for (let i = 0; i < length; i++) {
        const op = operationToOp(patch[i], options);
        const opResult = op.apply(doc);
        doc = opResult.doc;
        res.push(opResult);
    }
    return { doc, res };
}
