import { operationToOp } from '../../json-patch/codec/json';
import { isRoot, isChild } from '../../json-pointer';
export const xMove = (move, op) => {
    if (isRoot(move.path))
        return op;
    if (isChild(move.from, op.path)) {
        const pointer = [...move.path, ...op.path.slice(move.path.length)];
        const operation = op.toJson();
        operation.path = pointer;
        return operationToOp(operation, {});
    }
    return op;
};
