import { xforms } from './transforms';
export const transform = (accepted, proposed) => {
    const length = accepted.length;
    for (let i = 0; i < length; i++) {
        const against = accepted[i];
        const transformFunction = xforms[against.op()];
        if (transformFunction) {
            const transformed = [];
            for (const op of proposed) {
                const newOps = transformFunction(against, op);
                if (Array.isArray(newOps))
                    transformed.push(...newOps);
                else if (newOps)
                    transformed.push(newOps);
            }
            proposed = transformed;
        }
    }
    return proposed;
};
