import { CborEncoderStable } from './CborEncoderStable';
export class CborEncoderDag extends CborEncoderStable {
    writeUndef() {
        this.writeNull();
    }
    writeFloat(float) {
        if (float !== float)
            return this.writeNull();
        if (!Number.isFinite(float))
            return this.writeNull();
        super.writeFloat(float);
    }
    writeTag(tag, value) {
        if (tag === 42)
            this.writeTagHdr(tag);
        this.writeAny(value);
    }
}
