import { UbjsonEncoder } from '../ubjson/UbjsonEncoder';
import { UbjsonDecoder } from '../ubjson/UbjsonDecoder';
import { Writer } from '../../util/buffers/Writer';
const encoder = new UbjsonEncoder(new Writer());
const decoder = new UbjsonDecoder();
const pojo = {
    id: 123,
    foo: 'bar',
    tags: ['a', 'b', 'c'],
    binary: new Uint8Array([1, 2, 3]),
};
console.clear();
console.log('--------------------------------------------------');
console.log('Encoding UBJSON:');
const encoded = encoder.encode(pojo);
console.log(encoded);
console.log('--------------------------------------------------');
console.log('Decoding UBJSON:');
const decoded = decoder.read(encoded);
console.log(decoded);
console.log('--------------------------------------------------');
console.log('Binary data:');
const blob = encoder.encode({ binary: new Uint8Array([1, 2, 3]) });
console.log(Buffer.from(blob).toString());
