import { literal } from '../../../json-expression/util';
import { OpTree } from './tree';
import { toPath } from '../../../json-pointer/util';
export const jsonPatchOpToJsonOp = (operation) => {
    const op = operation.op;
    switch (op) {
        case 'test': {
            const value = literal(operation.value);
            const expression = [operation.not ? '!=' : '==', ['$', operation.path], value];
            return [[expression]];
        }
        case 'add': {
            return [[], [], [[0, operation.value]], [[0, toPath(operation.path)]]];
        }
        case 'remove': {
            const path = toPath(operation.path);
            return [[['$?', operation.path]], [[0, path]]];
        }
        case 'replace': {
            const path = toPath(operation.path);
            const test = path.length ? [['$?', operation.path]] : [];
            return [test, [[0, path]], [[1, operation.value]], [[1, path]]];
        }
        case 'move': {
            const path = toPath(operation.path);
            const from = toPath(operation.from);
            const test = from.length ? [['$?', operation.from]] : [];
            return [test, [[0, from]], [], [[0, path]]];
        }
        case 'copy': {
            const path = toPath(operation.path);
            const from = toPath(operation.from);
            return [
                [],
                [[0, from]],
                [],
                [
                    [0, from],
                    [0, path],
                ],
            ];
        }
    }
    return [[]];
};
export const toJsonOp = (patch) => {
    const tree = OpTree.from([[]]);
    for (const op of patch) {
        const otOp = jsonPatchOpToJsonOp(op);
        const opTree = OpTree.from(otOp);
        tree.compose(opTree);
    }
    return tree.toJson();
};
