export const validate = (op) => {
    if (!(op instanceof Array))
        return 1;
    if (op.length === 0)
        return 1;
    let last;
    for (let i = 0; i < op.length; i++) {
        const component = op[i];
        if (typeof component === 'number') {
            if (!component)
                return 2;
            if (component !== Math.round(component))
                return 2;
            if (component > 0) {
                const lastComponentIsRetain = typeof last === 'number' && last > 0;
                if (lastComponentIsRetain)
                    return 3;
            }
            else {
                const lastComponentIsDelete = typeof last === 'number' && last < 0;
                if (lastComponentIsDelete)
                    return 3;
            }
        }
        else if (component instanceof Uint8Array) {
            if (!component.length)
                return 2;
            const lastComponentIsInsert = last instanceof Uint8Array;
            if (lastComponentIsInsert)
                return 3;
        }
        else {
            return 2;
        }
        last = component;
    }
    const isLastRetain = typeof last === 'number' && last > 0;
    if (isLastRetain)
        return 4;
    return 0;
};
