export const append = (op, component) => {
    if (!component)
        return;
    if (!op.length) {
        op.push(component);
        return;
    }
    const lastIndex = op.length - 1;
    const last = op[lastIndex];
    if (typeof component === 'number') {
        if (typeof last === 'number') {
            if (component > 0 && last > 0)
                op[lastIndex] = last + component;
            else if (component < 0 && last < 0)
                op[lastIndex] = last + component;
            else
                op.push(component);
        }
        else
            op.push(component);
    }
    else if (component instanceof Uint8Array) {
        if (last instanceof Uint8Array) {
            const combined = new Uint8Array(last.length + component.length);
            combined.set(last, 0);
            combined.set(component, last.length);
            op[lastIndex] = combined;
        }
        else
            op.push(component);
    }
};
export const componentLength = (component) => {
    return typeof component === 'number' ? Math.abs(component) : component.length;
};
export const isDeleteComponent = (component) => {
    return typeof component === 'number' && component < 0;
};
export const trim = (op) => {
    if (!op.length)
        return;
    const last = op[op.length - 1];
    const isLastRetain = typeof last === 'number' && last > 0;
    if (isLastRetain)
        op.pop();
};
export const normalize = (op) => {
    const op2 = [];
    const length = op.length;
    for (let i = 0; i < length; i++)
        append(op2, op[i]);
    trim(op2);
    return op2;
};
export const chunk = (component, offset, maxLength) => {
    if (typeof component === 'number') {
        return component > 0 ? Math.min(component - offset, maxLength) : -Math.min(-component - offset, maxLength);
    }
    else if (component instanceof Uint8Array) {
        const end = Math.min(offset + maxLength, component.length);
        return component.subarray(offset, end);
    }
    return component;
};
