import type { Vars } from './Vars';
import type { Expression, Literal, OperatorDefinition, OperatorMap } from './types';
export declare const get: (path: string, data: unknown) => unknown;
export declare const throwOnUndef: (value: unknown, def?: unknown) => {} | null;
export declare const type: (value: unknown) => string;
export declare const num: (value: unknown) => number;
export declare const int: (value: unknown) => number;
export declare const str: (value: unknown) => string;
export declare const cmp: (a: any, b: any) => 1 | -1 | 0;
export declare const betweenNeNe: (val: any, min: any, max: any) => boolean;
export declare const betweenNeEq: (val: any, min: any, max: any) => boolean;
export declare const betweenEqNe: (val: any, min: any, max: any) => boolean;
export declare const betweenEqEq: (val: any, min: any, max: any) => boolean;
export declare const slash: (a: unknown, b: unknown) => number;
export declare const mod: (a: unknown, b: unknown) => number;
export declare const len: (value: unknown) => number;
export declare const member: (container: unknown, index: unknown) => unknown;
export declare const asBin: (value: unknown) => Uint8Array;
export declare const asStr: (value: unknown) => string;
export declare const starts: (outer: unknown, inner: unknown) => boolean;
export declare const contains: (outer: unknown, inner: unknown) => boolean;
export declare const ends: (outer: unknown, inner: unknown) => boolean;
export declare const substr: (probablyString: string | unknown, from: number | unknown, to: number | unknown) => string;
export declare const isEmail: (value: unknown) => boolean;
export declare const isHostname: (value: unknown) => boolean;
export declare const isIp4: (value: unknown) => boolean;
export declare const isIp6: (value: unknown) => boolean;
export declare const isUuid: (value: unknown) => boolean;
export declare const isUri: (value: unknown) => boolean;
export declare const isDuration: (value: unknown) => boolean;
export declare const isDate: (value: unknown) => boolean;
export declare const isTime: (value: unknown) => boolean;
export declare const isDateTime: (str: unknown) => boolean;
export declare const u8: (bin: unknown, pos: unknown) => number;
export declare const asArr: (value: unknown) => unknown[];
export declare const head: (operand1: unknown, operand2: unknown) => unknown;
export declare const concat: (arrays: unknown[]) => unknown[];
export declare const isInArr: (arr: unknown, what: unknown) => boolean;
export declare const isInArr2: (arr: unknown, check: (item: unknown) => boolean) => boolean;
export declare const fromEntries: (maybeEntries: unknown) => Record<string, unknown>;
export declare const indexOf: (container: unknown, item: unknown) => -1 | number;
export declare const indexOf2: (container: unknown, check: (item: unknown) => boolean) => -1 | number;
export declare const zip: (maybeArr1: unknown, maybeArr2: unknown) => [
    unknown,
    unknown
][];
export declare const filter: (arr: unknown[], varname: string, vars: Vars, run: () => unknown) => unknown;
export declare const map: (arr: unknown[], varname: string, vars: Vars, run: () => unknown) => unknown;
export declare const reduce: (arr: unknown[], initialValue: unknown, accname: string, varname: string, vars: Vars, run: () => unknown) => unknown;
export declare const asObj: (value: unknown) => object;
export declare const keys: (value: unknown) => string[];
export declare const values: (value: unknown) => unknown[];
export declare const entries: (value: unknown) => [key: string, value: unknown][];
export declare const isLiteral: (value: unknown) => boolean;
export declare const asLiteral: <T>(value: Literal<T>) => T;
export declare const literal: <T = unknown>(value: T) => T | [T];
export declare const assertFixedArity: (operator: string, arity: number, expr: Expression) => void;
export declare const assertVariadicArity: (operator: string, expr: Expression) => void;
export declare const assertArity: (operator: string, arity: number | [
    min: number,
    max: number
], expr: Expression) => void;
export declare const operatorsToMap: (operators: OperatorDefinition<Expression>[]) => OperatorMap;
export declare const parseVar: (name: string) => [name: string, pointer: string];
