import { Expression } from '../codegen-steps';
export const logicalOperators = [
    [
        '&&',
        ['and'],
        -1,
        (expr, ctx) => {
            return expr.slice(1).reduce((acc, e) => acc && ctx.eval(e, ctx), true);
        },
        (ctx) => {
            const js = ctx.operands.map((expr) => `(${expr})`).join('&&');
            return new Expression(js);
        },
    ],
    [
        '||',
        ['or'],
        -1,
        (expr, ctx) => {
            return expr.slice(1).reduce((acc, e) => acc || ctx.eval(e, ctx), false);
        },
        (ctx) => {
            const js = ctx.operands.map((expr) => `(${expr})`).join('||');
            return new Expression(js);
        },
    ],
    [
        '!',
        ['not'],
        1,
        (expr, ctx) => {
            return !ctx.eval(expr[1], ctx);
        },
        (ctx) => {
            const js = `!(${ctx.operands[0]})`;
            return new Expression(js);
        },
    ],
];
