import { Expression } from '../codegen-steps';
import * as util from '../util';
export const containerOperators = [
    [
        'len',
        [],
        1,
        (expr, ctx) => {
            return util.len(ctx.eval(expr[1], ctx));
        },
        (ctx) => {
            ctx.link(util.len, 'len');
            const js = `len(${ctx.operands[0]})`;
            return new Expression(js);
        },
    ],
    [
        '[]',
        ['member'],
        2,
        (expr, ctx) => {
            const container = ctx.eval(expr[1], ctx);
            const index = ctx.eval(expr[2], ctx);
            return util.member(container, index);
        },
        (ctx) => {
            ctx.link(util.member, 'member');
            const js = `member((${ctx.operands[0]}),(${ctx.operands[1]}))`;
            return new Expression(js);
        },
    ],
];
