import * as util from '../util';
import { Expression } from '../codegen-steps';
const binaryOperands = (expr, ctx) => {
    const left = ctx.eval(expr[1], ctx);
    const right = ctx.eval(expr[2], ctx);
    return [left, right];
};
export const binaryOperators = [
    [
        'u8',
        [],
        2,
        (expr, ctx) => {
            const [bin, index] = binaryOperands(expr, ctx);
            return util.u8(bin, index);
        },
        (ctx) => {
            ctx.link(util.u8, 'u8');
            const js = `u8((${ctx.operands[0]}),(${ctx.operands[1]}))`;
            return new Expression(js);
        },
    ],
];
