import { get, toPath, validateJsonPointer } from '../json-pointer';
export class Vars {
    env;
    vars = new Map();
    constructor(env) {
        this.env = env;
    }
    get(name) {
        if (!name)
            return this.env;
        return this.vars.get(name);
    }
    set(name, value) {
        if (!name)
            throw new Error('Invalid varname.');
        this.vars.set(name, value);
    }
    has(name) {
        if (!name)
            return true;
        return this.vars.has(name);
    }
    del(name) {
        if (!name)
            throw new Error('Invalid varname.');
        return this.vars.delete(name);
    }
    find(name, pointer) {
        const data = this.get(name);
        validateJsonPointer(pointer);
        const path = toPath(pointer);
        return get(data, path);
    }
}
