import { compare, toDisplayString } from '../../../json-crdt-patch/clock';
import { printTree } from '../../../util/print/printTree';
import { UNDEFINED } from '../../model/Model';
export class ValNode {
    doc;
    id;
    val;
    constructor(doc, id, val) {
        this.doc = doc;
        this.id = id;
        this.val = val;
    }
    set(val) {
        if (compare(val, this.val) <= 0 && this.val.sid !== 0)
            return;
        if (compare(val, this.id) <= 0)
            return;
        const oldVal = this.val;
        this.val = val;
        return oldVal;
    }
    node() {
        return this.val.sid === 0 ? UNDEFINED : this.child();
    }
    view() {
        return this.node().view();
    }
    children(callback) {
        callback(this.node());
    }
    child() {
        return this.doc.index.get(this.val);
    }
    container() {
        const child = this.node();
        return child ? child.container() : undefined;
    }
    api = undefined;
    toString(tab = '') {
        const node = this.node();
        const header = this.constructor.name + ' ' + toDisplayString(this.id);
        return header + printTree(tab, [(tab) => (node ? node.toString(tab) : toDisplayString(this.val))]);
    }
}
