import { compare, toDisplayString } from '../../../json-crdt-patch/clock';
import { printTree } from '../../../util/print/printTree';
export class ObjNode {
    doc;
    id;
    keys = new Map();
    constructor(doc, id) {
        this.doc = doc;
        this.id = id;
    }
    get(key) {
        const id = this.keys.get(key);
        if (!id)
            return undefined;
        return this.doc.index.get(id);
    }
    put(key, id) {
        const currentId = this.keys.get(key);
        if (currentId && compare(currentId, id) >= 0)
            return;
        this.keys.set(key, id);
        return currentId;
    }
    nodes(callback) {
        const index = this.doc.index;
        this.keys.forEach((id, key) => callback(index.get(id), key));
    }
    children(callback) {
        const index = this.doc.index;
        this.keys.forEach((id, key) => callback(index.get(id)));
    }
    child() {
        return undefined;
    }
    container() {
        return this;
    }
    _tick = 0;
    _view = {};
    view() {
        const doc = this.doc;
        const tick = doc.clock.time + doc.tick;
        const _view = this._view;
        if (this._tick === tick)
            return _view;
        const view = {};
        const index = doc.index;
        let useCache = true;
        this.keys.forEach((id, key) => {
            const value = index.get(id).view();
            if (value !== undefined) {
                if (_view[key] !== value)
                    useCache = false;
                view[key] = value;
            }
            else if (_view[key] !== undefined)
                useCache = false;
        });
        return useCache ? _view : ((this._tick = tick), (this._view = view));
    }
    api = undefined;
    toString(tab = '') {
        const header = this.constructor.name + ' ' + toDisplayString(this.id);
        return (header +
            printTree(tab, [...this.keys.entries()].map(([key, id]) => (tab) => JSON.stringify(key) + printTree(tab + ' ', [(tab) => this.doc.index.get(id).toString(tab)]))));
    }
}
