import { ITimestampStruct } from '../../../json-crdt-patch/clock';
import type { Model } from '../../model';
import type { Printable } from '../../../util/print/types';
import type { JsonNode, JsonNodeView } from '..';
export declare class ObjNode<Value extends Record<string, JsonNode> = Record<string, JsonNode>> implements JsonNode<Readonly<JsonNodeView<Value>>>, Printable {
    protected readonly doc: Model<any>;
    readonly id: ITimestampStruct;
    readonly keys: Map<string, ITimestampStruct>;
    constructor(doc: Model<any>, id: ITimestampStruct);
    get<K extends keyof Value>(key: K): undefined | Value[K];
    put(key: string, id: ITimestampStruct): undefined | ITimestampStruct;
    nodes(callback: (node: JsonNode, key: string) => void): void;
    children(callback: (node: JsonNode) => void): void;
    child(): undefined;
    container(): JsonNode | undefined;
    private _tick;
    private _view;
    view(): Readonly<JsonNodeView<Value>>;
    api: undefined | unknown;
    toString(tab?: string): string;
}
