import { AbstractRga } from '../rga/AbstractRga';
import { tick } from '../../../json-crdt-patch/clock';
import { printBinary } from '../../../util/print/printBinary';
import { printTree } from '../../../util/print/printTree';
const Empty = [];
export class ArrChunk {
    id;
    span;
    del;
    data;
    len;
    p;
    l;
    r;
    p2;
    l2;
    r2;
    s;
    constructor(id, span, data) {
        this.id = id;
        this.span = span;
        this.len = data ? span : 0;
        this.del = !data;
        this.p = undefined;
        this.l = undefined;
        this.r = undefined;
        this.s = undefined;
        this.data = data;
    }
    merge(data) {
        this.data.push(...data);
        this.span = this.data.length;
    }
    split(ticks) {
        const span = this.span;
        this.span = ticks;
        if (!this.del) {
            const data = this.data;
            const rightData = data.splice(ticks);
            const chunk = new ArrChunk(tick(this.id, ticks), span - ticks, rightData);
            return chunk;
        }
        return new ArrChunk(tick(this.id, ticks), span - ticks, undefined);
    }
    delete() {
        this.del = true;
        this.data = undefined;
    }
    clone() {
        return new ArrChunk(this.id, this.span, this.data ? [...this.data] : undefined);
    }
}
export class ArrNode extends AbstractRga {
    doc;
    constructor(doc, id) {
        super(id);
        this.doc = doc;
    }
    get(position) {
        const pair = this.findChunk(position);
        if (!pair)
            return undefined;
        return pair[0].data[pair[1]];
    }
    getNode(position) {
        const id = this.get(position);
        if (!id)
            return undefined;
        return this.doc.index.get(id);
    }
    getById(id) {
        const chunk = this.findById(id);
        if (!chunk || chunk.del)
            return undefined;
        const offset = id.time - chunk.id.time;
        return chunk.data[offset];
    }
    createChunk(id, data) {
        return new ArrChunk(id, data ? data.length : 0, data);
    }
    onChange() {
        this._view = Empty;
    }
    toStringName() {
        return super.toStringName();
    }
    child() {
        return undefined;
    }
    container() {
        return this;
    }
    _tick = 0;
    _view = Empty;
    view() {
        const doc = this.doc;
        const tick = doc.clock.time + doc.tick;
        const _view = this._view;
        if (this._tick === tick)
            return _view;
        const view = [];
        const index = doc.index;
        let useCache = true;
        for (let chunk = this.first(); chunk; chunk = this.next(chunk)) {
            if (chunk.del)
                continue;
            for (const node of chunk.data) {
                const element = index.get(node).view();
                if (_view[view.length] !== element)
                    useCache = false;
                view.push(element);
            }
        }
        if (_view.length !== view.length)
            useCache = false;
        return useCache ? _view : ((this._tick = tick), (this._view = view));
    }
    children(callback) {
        const index = this.doc.index;
        for (let chunk = this.first(); chunk; chunk = this.next(chunk))
            if (!chunk.del)
                for (const node of chunk.data)
                    callback(index.get(node));
    }
    api = undefined;
    printChunk(tab, chunk) {
        const pos = this.pos(chunk);
        let valueTree = '';
        if (!chunk.del) {
            const index = this.doc.index;
            valueTree = printTree(tab, chunk.data.map((id, i) => (tab) => `[${pos + i}]: ${index.get(id).toString(tab + '    ' + ' '.repeat(String(i).length))}`));
        }
        return (this.formatChunk(chunk) +
            valueTree +
            printBinary(tab, [
                chunk.l ? (tab) => this.printChunk(tab, chunk.l) : null,
                chunk.r ? (tab) => this.printChunk(tab, chunk.r) : null,
            ]));
    }
}
