import { Emitter } from '../../../../util/events/Emitter';
export class NodeEvents extends Emitter {
    api;
    constructor(api) {
        super();
        this.api = api;
    }
    viewSubs = new Set();
    _view = undefined;
    onModelChange = () => {
        const _view = this._view;
        const view = this.api.node.view();
        const viewHasChanged = _view !== view;
        this._view = view;
        if (viewHasChanged)
            this.emit(new CustomEvent('view'));
    };
    setupViewEvents() {
        this._view = this.api.node.view();
        this.api.api.events.on('change', this.onModelChange);
    }
    on(type, listener, options) {
        if (type === 'view')
            this.viewSubs.add(listener);
        const shouldSubscribeToModelChanges = this.viewSubs.size === 1;
        if (shouldSubscribeToModelChanges)
            this.setupViewEvents();
        super.on(type, listener, options);
    }
    off(type, listener, options) {
        if (type === 'view')
            this.viewSubs.delete(listener);
        const shouldUnsubscribeFromModelChanges = this.viewSubs.size === 1;
        if (shouldUnsubscribeFromModelChanges)
            this.api.api.events.off('change', this.onModelChange);
        super.off(type, listener, options);
    }
}
