import { VecNode, ConNode, ObjNode, ArrNode, BinNode, StrNode, ValNode } from '../../nodes';
import { ArrApi, BinApi, ConApi, ObjApi, StrApi, VecApi, ValApi } from './nodes';
import { Emitter } from '../../../util/events/Emitter';
import { PatchBuilder } from '../../../json-crdt-patch/PatchBuilder';
export class ModelApi {
    model;
    builder;
    next = 0;
    constructor(model) {
        this.model = model;
        this.builder = new PatchBuilder(this.model.clock);
    }
    changeQueued = false;
    queueChange = () => {
        if (this.changeQueued)
            return;
        this.changeQueued = true;
        queueMicrotask(() => {
            this.changeQueued = false;
            const et = this.et;
            if (et)
                et.emit(new CustomEvent('change'));
        });
    };
    et = undefined;
    get events() {
        let et = this.et;
        if (!et) {
            this.et = et = new Emitter();
            this.model.onchange = this.queueChange;
        }
        return et;
    }
    wrap(node) {
        if (node instanceof ValNode)
            return node.api || (node.api = new ValApi(node, this));
        else if (node instanceof StrNode)
            return node.api || (node.api = new StrApi(node, this));
        else if (node instanceof BinNode)
            return node.api || (node.api = new BinApi(node, this));
        else if (node instanceof ArrNode)
            return node.api || (node.api = new ArrApi(node, this));
        else if (node instanceof ObjNode)
            return node.api || (node.api = new ObjApi(node, this));
        else if (node instanceof ConNode)
            return node.api || (node.api = new ConApi(node, this));
        else if (node instanceof VecNode)
            return node.api || (node.api = new VecApi(node, this));
        else
            throw new Error('UNKNOWN_NODE');
    }
    get r() {
        return new ValApi(this.model.root, this);
    }
    get node() {
        return this.r.get();
    }
    in(path) {
        return this.r.in(path);
    }
    find(path) {
        return this.node.find(path);
    }
    val(path) {
        return this.node.val(path);
    }
    vec(path) {
        return this.node.tup(path);
    }
    str(path) {
        return this.node.str(path);
    }
    bin(path) {
        return this.node.bin(path);
    }
    arr(path) {
        return this.node.arr(path);
    }
    obj(path) {
        return this.node.obj(path);
    }
    const(path) {
        return this.node.const(path);
    }
    root(json) {
        const builder = this.builder;
        builder.root(builder.json(json));
        this.apply();
        return this;
    }
    apply() {
        const ops = this.builder.patch.ops;
        const length = ops.length;
        const model = this.model;
        for (let i = this.next; i < length; i++)
            model.applyOperation(ops[i]);
        this.next = length;
        model.tick++;
        model.onchange?.();
    }
    advance() {
        this.next = this.builder.patch.ops.length;
        const model = this.model;
        model.tick++;
        model.onchange?.();
    }
    view() {
        return this.model.view();
    }
    flush() {
        const patch = this.builder.flush();
        this.next = 0;
        return patch;
    }
}
