import { NodeBuilder } from '../../json-crdt-patch/builder/DelayedValueBuilder';
import { konst } from '../../json-crdt-patch/builder/Konst';
export const ext = (extensionId, nodeBuilder) => new NodeBuilder((builder) => {
    const buf = new Uint8Array([extensionId, 0, 0]);
    const tupleId = builder.vec();
    buf[1] = tupleId.sid % 256;
    buf[2] = tupleId.time % 256;
    const bufId = builder.constOrJson(konst(buf));
    const valueId = nodeBuilder.build(builder);
    builder.insVec(tupleId, [
        [0, bufId],
        [1, valueId],
    ]);
    return tupleId;
});
