import type { JsonCrdtPatchOpcode } from '../../constants';
import { JsonCodecTimestamp } from '../verbose/types';
export type CompactCodecPatch = [
    header: [
        id: CompactCodecTimestamp,
        meta?: unknown
    ],
    ...ops: CompactCodecOperation[]
];
export type CompactCodecOperation = CompactCodecNewConOperation | CompactCodecNewValOperation | CompactCodecNewObjOperation | CompactCodecNewVecOperation | CompactCodecNewStrOperation | CompactCodecNewBinOperation | CompactCodecNewArrOperation | CompactCodecInsValOperation | CompactCodecInsObjOperation | CompactCodecInsVecOperation | CompactCodecInsStrOperation | CompactCodecInsBinOperation | CompactCodecInsArrOperation | CompactCodecDelOperation | CompactCodecNopOperation;
export type CompactCodecTimestamp = [
    sessionId: number,
    time: number
] | number;
export type CompactCodecTimespan = [
    sessionId: number,
    time: number,
    span: number
] | [
    time: number,
    span: number
];
export type CompactCodecNewConOperation = [
    op: JsonCrdtPatchOpcode.new_con,
    value?: unknown | undefined | CompactCodecTimestamp,
    timestamp?: boolean
];
export type CompactCodecNewValOperation = [
    op: JsonCrdtPatchOpcode.new_val,
    value: CompactCodecTimestamp
];
export type CompactCodecNewObjOperation = [
    op: JsonCrdtPatchOpcode.new_obj
];
export type CompactCodecNewVecOperation = [
    op: JsonCrdtPatchOpcode.new_vec
];
export type CompactCodecNewStrOperation = [
    op: JsonCrdtPatchOpcode.new_str
];
export type CompactCodecNewBinOperation = [
    op: JsonCrdtPatchOpcode.new_bin
];
export type CompactCodecNewArrOperation = [
    op: JsonCrdtPatchOpcode.new_arr
];
export type CompactCodecInsValOperation = [
    op: JsonCrdtPatchOpcode.ins_val,
    obj: CompactCodecTimestamp,
    value: CompactCodecTimestamp
];
export type CompactCodecInsObjOperation = [
    op: JsonCrdtPatchOpcode.ins_obj,
    obj: CompactCodecTimestamp,
    value: Array<[key: string, value: CompactCodecTimestamp]>
];
export type CompactCodecInsVecOperation = [
    op: JsonCrdtPatchOpcode.ins_vec,
    obj: CompactCodecTimestamp,
    value: Array<[index: number, value: CompactCodecTimestamp]>
];
export type CompactCodecInsStrOperation = [
    op: JsonCrdtPatchOpcode.ins_str,
    obj: CompactCodecTimestamp,
    after: CompactCodecTimestamp,
    value: string
];
export type CompactCodecInsBinOperation = [
    op: JsonCrdtPatchOpcode.ins_bin,
    obj: CompactCodecTimestamp,
    after: CompactCodecTimestamp,
    value: string
];
export type CompactCodecInsArrOperation = [
    op: JsonCrdtPatchOpcode.ins_arr,
    obj: CompactCodecTimestamp,
    after: CompactCodecTimestamp,
    values: JsonCodecTimestamp[]
];
export type CompactCodecDelOperation = [
    op: JsonCrdtPatchOpcode.del,
    obj: CompactCodecTimestamp,
    what: CompactCodecTimespan[]
];
export type CompactCodecNopOperation = [
    op: JsonCrdtPatchOpcode.nop,
    len?: number
];
