import { VectorClock, ts } from '../../clock';
export class ClockDecoder {
    table = [];
    clock;
    static fromArr(arr) {
        const decoder = new ClockDecoder(arr[0], arr[1]);
        const length = arr.length;
        for (let i = 2; i < length; i += 2)
            decoder.pushTuple(arr[i], arr[i + 1]);
        return decoder;
    }
    constructor(sid, time) {
        this.clock = new VectorClock(sid, time + 1);
        this.table.push(ts(sid, time));
    }
    pushTuple(sid, time) {
        const id = ts(sid, time);
        this.clock.observe(id, 1);
        this.table.push(id);
    }
    decodeId(sessionIndex, timeDiff) {
        if (!sessionIndex)
            return ts(0, timeDiff);
        const clock = this.table[sessionIndex - 1];
        if (!clock)
            throw new Error('INVALID_CLOCK_TABLE');
        return ts(clock.sid, clock.time - timeDiff);
    }
}
