import type { IClock, IVectorClock, ITimestampStruct, ITimespanStruct } from './types';
export declare class Timestamp implements ITimestampStruct {
    readonly sid: number;
    time: number;
    constructor(sid: number, time: number);
}
export declare class Timespan implements ITimespanStruct {
    readonly sid: number;
    time: number;
    span: number;
    constructor(sid: number, time: number, span: number);
}
export declare const ts: (sid: number, time: number) => ITimestampStruct;
export declare const tss: (sid: number, time: number, span: number) => ITimespanStruct;
export declare const tick: (stamp: ITimestampStruct, cycles: number) => ITimestampStruct;
export declare const equal: (ts1: ITimestampStruct, ts2: ITimestampStruct) => boolean;
export declare const compare: (ts1: ITimestampStruct, ts2: ITimestampStruct) => -1 | 0 | 1;
export declare const contains: (ts1: ITimestampStruct, span1: number, ts2: ITimestampStruct, span2: number) => boolean;
export declare const containsId: (ts1: ITimestampStruct, span1: number, ts2: ITimestampStruct) => boolean;
export declare const toDisplayString: (id: ITimestampStruct) => string;
export declare const interval: (ts: ITimestampStruct, tick: number, span: number) => ITimespanStruct;
export declare class LogicalClock extends Timestamp implements IClock {
    tick(cycles: number): ITimestampStruct;
}
export declare class VectorClock extends LogicalClock implements IVectorClock {
    readonly peers: Map<number, ITimestampStruct>;
    observe(id: ITimestampStruct, span: number): void;
    clone(): VectorClock;
    fork(sessionId: number): VectorClock;
    toString(tab?: string): string;
}
export declare class ServerVectorClock extends LogicalClock implements IVectorClock {
    readonly peers: Map<number, ITimespanStruct>;
    observe(ts: ITimespanStruct, span: number): void;
    clone(): ServerVectorClock;
    fork(): ServerVectorClock;
}
