import { NodeBuilder } from './DelayedValueBuilder';
export var nodes;
(function (nodes) {
    class con extends NodeBuilder {
        raw;
        type = 'con';
        constructor(raw) {
            super((builder) => builder.const(raw));
            this.raw = raw;
        }
    }
    nodes.con = con;
    class str extends NodeBuilder {
        raw;
        type = 'str';
        constructor(raw) {
            super((builder) => builder.json(raw));
            this.raw = raw;
        }
    }
    nodes.str = str;
    class bin extends NodeBuilder {
        raw;
        type = 'bin';
        constructor(raw) {
            super((builder) => builder.json(raw));
            this.raw = raw;
        }
    }
    nodes.bin = bin;
    class val extends NodeBuilder {
        value;
        type = 'val';
        constructor(value) {
            super((builder) => {
                const valId = builder.val();
                const valueId = value.build(builder);
                builder.setVal(valId, valueId);
                return valId;
            });
            this.value = value;
        }
    }
    nodes.val = val;
    class vec extends NodeBuilder {
        value;
        type = 'vec';
        constructor(value) {
            super((builder) => {
                const vecId = builder.vec();
                const length = value.length;
                if (length) {
                    const elementPairs = [];
                    for (let i = 0; i < length; i++) {
                        const element = value[i];
                        const elementId = element.build(builder);
                        elementPairs.push([i, elementId]);
                    }
                    builder.insVec(vecId, elementPairs);
                }
                return vecId;
            });
            this.value = value;
        }
    }
    nodes.vec = vec;
    class obj extends NodeBuilder {
        obj;
        opt;
        type = 'obj';
        constructor(obj, opt) {
            super((builder) => {
                const objId = builder.obj();
                const keyValuePairs = [];
                const merged = { ...obj, ...opt };
                const keys = Object.keys(merged);
                const length = keys.length;
                if (length) {
                    for (let i = 0; i < length; i++) {
                        const key = keys[i];
                        const valueId = merged[key].build(builder);
                        keyValuePairs.push([key, valueId]);
                    }
                    builder.insObj(objId, keyValuePairs);
                }
                return objId;
            });
            this.obj = obj;
            this.opt = opt;
        }
        optional() {
            return this;
        }
    }
    nodes.obj = obj;
    class arr extends NodeBuilder {
        arr;
        type = 'arr';
        constructor(arr) {
            super((builder) => {
                const arrId = builder.arr();
                const length = arr.length;
                if (length) {
                    const valueIds = [];
                    for (let i = 0; i < length; i++)
                        valueIds.push(arr[i].build(builder));
                    builder.insArr(arrId, arrId, valueIds);
                }
                return arrId;
            });
            this.arr = arr;
        }
    }
    nodes.arr = arr;
})(nodes || (nodes = {}));
export const schema = {
    con: (raw) => new nodes.con(raw),
    str: (str) => new nodes.str(str || ''),
    bin: (bin) => new nodes.bin(bin),
    val: (val) => new nodes.val(val),
    vec: (...vec) => new nodes.vec(vec),
    obj: (obj, opt) => new nodes.obj(obj, opt),
    arr: (arr) => new nodes.arr(arr),
};
export const s = schema;
