export interface TestCaseNil {
    nil: null;
    msgpack: string[];
}
export interface TestCaseBool {
    bool: boolean;
    msgpack: string[];
}
export interface TestCaseBinary {
    binary: string;
    msgpack: string[];
}
export interface TestCaseNumber {
    number: number;
    msgpack: string[];
}
export interface TestCaseBignum {
    bignum: string;
    msgpack: string[];
}
export interface TestCaseString {
    string: string;
    msgpack: string[];
}
export interface TestCaseArray {
    array: unknown[];
    msgpack: string[];
}
export interface TestCaseMap {
    map: object;
    msgpack: string[];
}
export interface TestCaseTimestamp {
    timestamp: [number, number];
    msgpack: string[];
}
export interface TestCaseExt {
    ext: [number, string];
    msgpack: string[];
}
export type TestCase = TestCaseNil | TestCaseBool | TestCaseBinary | TestCaseNumber | TestCaseBignum | TestCaseString | TestCaseArray | TestCaseMap | TestCaseTimestamp | TestCaseExt;
export declare const testSuites: Record<string, TestCase[]>;
