import { BehaviorSubject, of } from 'rxjs';
import { switchMap } from 'rxjs/operators';
export class BasicBlock {
    model;
    v$;
    constructor(version, model) {
        this.model = model;
        this.v$ = new BehaviorSubject(version);
    }
    fork() {
        return new BasicBlock(this.v$.getValue(), this.model.fork());
    }
    data$() {
        return this.v$.pipe(switchMap(() => of(this.model.getData())));
    }
    getData() {
        return this.model.getData();
    }
    apply(patch) {
        this.model.apply(patch);
        this.v$.next(this.v$.getValue());
    }
}
export class Branch {
    base$;
    head$;
    patches;
    batches = [];
    constructor(base) {
        this.base$ = new BehaviorSubject(base);
        this.patches = [];
        this.head$ = new BehaviorSubject(base.fork());
    }
    cutBatch() {
        this.batches.push(this.patches);
        this.patches = [];
    }
    commit(patch) {
        this.patches.push(patch);
        this.head$.getValue().apply(patch);
    }
    rebase(patches) {
        const base = this.base$.getValue();
        for (const patch of patches)
            base.apply(patch);
        const head = base.fork();
        for (const patch of this.patches)
            head.apply(patch);
        this.head$.next(head);
    }
    reset(base) {
        this.base$.next(base);
        const patches = this.patches;
        this.patches = [];
        this.head$.next(base.fork());
        return patches;
    }
}
